def calculate_area(vertices) -> float:
    """
    Calculates the area of the polygon.

    Returns:
        float: The area of the polygon.

    Raises:
        ValueError: If the polygon has less than 3 vertices.
    """
    if len(vertices) < 3:
        raise ValueError("A polygon must have at least 3 vertices.")

    area = 0.0

    for i in range(len(vertices)):
        x1, y1 = vertices[i]
        x2, y2 = vertices[(i + 1) % len(vertices)]
        area += (x1 * y2) - (x2 * y1)

    area = abs(area) / 2.0

    return area

if __name__ == "__main__":
    # Get all data.
    N = int(input())

    vertices = []
    for i in range(N):
        line = input()
        item = [ int(i) for i in line.strip().split(' ') ]
        item = tuple(item)
        vertices.append(item)

    # Calculate area.
    area = calculate_area(vertices)

    print(area)